/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbNamedPipe;
import jcifs.util.Encdec;

public class DcerpcPipeHandle
extends DcerpcHandle {
    SmbNamedPipe pipe;
    SmbFileInputStream in;
    OutputStream out = null;
    boolean isStart = true;

    public DcerpcPipeHandle(String url, NtlmPasswordAuthentication auth) throws UnknownHostException, MalformedURLException, DcerpcException {
        this.binding = DcerpcHandle.parseBinding(url);
        url = "smb://" + this.binding.server + "/IPC$/" + this.binding.endpoint.substring(6);
        this.pipe = new SmbNamedPipe(url, 27198979, auth);
    }

    protected void doSendFragment(byte[] buf, int off, int length) throws IOException {
        this.in = (SmbFileInputStream)this.pipe.getNamedPipeInputStream();
        this.out = this.pipe.getNamedPipeOutputStream();
        this.out.write(buf, off, length);
    }

    protected void doReceiveFragment(byte[] buf) throws IOException {
        if (buf.length < this.max_recv) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (buf[0] != 5 && buf[1] != 0) {
            throw new IOException("Unexpected DCERPC PDU header");
        }
        int flags = buf[3] & 0xFF;
        this.isStart = (flags & 2) == 2;
        short length = Encdec.dec_uint16le(buf, 8);
        if (length > this.max_recv) {
            throw new IOException("Unexpected fragment length: " + length);
        }
        for (int off = this.isStart ? this.in.read(buf, 0, 1024) : this.in.readDirect(buf, 0, buf.length); off < length; off += this.in.readDirect(buf, off, length - off)) {
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }
}

