/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;

public final class SSLServerSocketImpl
extends SSLServerSocket {
    private SSLContextImpl a;
    private boolean b = false;
    private boolean c = true;
    private boolean d = true;
    private String[] e = null;
    private boolean f = false;

    public SSLServerSocketImpl(int n, int n2, SSLContextImpl sSLContextImpl) throws IOException, SSLException {
        super(n, n2);
        if (sSLContextImpl == null) {
            throw new SSLException("No Authentication context given");
        }
        this.a = sSLContextImpl;
        this.e = SSLSocketImpl.getDefaultSuites();
    }

    public SSLServerSocketImpl(int n, int n2, InetAddress inetAddress, SSLContextImpl sSLContextImpl) throws IOException {
        super(n, n2, inetAddress);
        if (sSLContextImpl == null) {
            throw new SSLException("No Authentication context given");
        }
        this.a = sSLContextImpl;
        this.e = SSLSocketImpl.getDefaultSuites();
    }

    public Socket accept() throws IOException {
        this.a();
        SSLSocketImpl sSLSocketImpl = this.c ? new SSLSocketImpl(this.a, this.b) : new SSLSocketImpl(this.a);
        sSLSocketImpl.setEnableSessionCreation(this.d);
        sSLSocketImpl.setEnabledCipherSuites(this.e);
        this.implAccept(sSLSocketImpl);
        sSLSocketImpl.b();
        return sSLSocketImpl;
    }

    private final void a() throws IOException {
        if (this.f) {
            return;
        }
        SSLServerSocketImpl sSLServerSocketImpl = this;
        synchronized (sSLServerSocketImpl) {
            if (!this.f) {
                SSLSocketImpl sSLSocketImpl = this.c ? new SSLSocketImpl(this.a, this.b) : new SSLSocketImpl(this.a);
                sSLSocketImpl.setEnableSessionCreation(this.d);
                sSLSocketImpl.setEnabledCipherSuites(this.e);
                String[] stringArray = this.e;
                Handshaker handshaker = sSLSocketImpl.d();
                int n = 0;
                while (n < stringArray.length) {
                    if (handshaker.canUseCipherSuite(stringArray[n])) {
                        this.f = true;
                        break;
                    }
                    ++n;
                }
                if (!this.f) {
                    throw new SSLException("No available certificate corresponds to the SSL cipher suites which are enabled.");
                }
            }
        }
    }

    public boolean getEnableSessionCreation() {
        return this.d;
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.e.clone();
    }

    public boolean getNeedClientAuth() {
        return this.b;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSpec.getSupportedCipherSuites();
    }

    public boolean getUseClientMode() {
        return this.c ^ true;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.d = bl;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("cipher suites to enable can not be null");
        }
        this.e = SSLSocketImpl.a(stringArray);
    }

    public void setNeedClientAuth(boolean bl) {
        this.b = bl;
    }

    public void setUseClientMode(boolean bl) {
        this.c = bl ^ true;
    }

    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

