/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.AVA;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerOutputStream;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;

class RDN {
    protected AVA[] assertion;

    RDN(int n) {
        this.assertion = new AVA[n];
    }

    RDN(DerValue derValue) throws IOException {
        if (derValue.tag != 49) {
            throw new IOException("X500 RDN");
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSet(5);
        this.assertion = new AVA[derValueArray.length];
        int n = 0;
        while (n < derValueArray.length) {
            this.assertion[n] = new AVA(derValueArray[n]);
            ++n;
        }
    }

    RDN(String string) throws IOException {
        int n = string.indexOf(43);
        if (n == -1 || n > 0 && string.charAt(n - 1) == '\\' && string.indexOf(43, n + 1) == -1) {
            this.assertion = new AVA[1];
            this.assertion[0] = new AVA(new StringReader(string));
        } else {
            String string2;
            int n2;
            Vector<String> vector = new Vector<String>(3);
            int n3 = 0;
            boolean bl = false;
            int n4 = 0;
            while ((n2 = string.indexOf(43, n4)) > 0) {
                if (string.charAt(n2 - 1) != '\\') {
                    string2 = string.substring(n3, n2).trim();
                    if (string2.length() == 0) {
                        throw new IOException("empty AVA in RDN \"" + string + "\"");
                    }
                    vector.addElement(string2);
                    n3 = n2 + 1;
                }
                n4 = n2 + 1;
            }
            string2 = string.substring(n3).trim();
            if (string2.length() == 0) {
                throw new IOException("empty AVA in RDN \"" + string + "\"");
            }
            vector.addElement(string2);
            this.assertion = new AVA[vector.size()];
            Enumeration enumeration = vector.elements();
            int n5 = 0;
            while (enumeration.hasMoreElements()) {
                this.assertion[n5++] = new AVA(new StringReader((String)enumeration.nextElement()));
            }
        }
    }

    void a(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOrderedSetOf((byte)49, this.assertion);
    }

    boolean a(RDN rDN) {
        if (rDN == this) {
            return true;
        }
        if (this.assertion.length != rDN.assertion.length) {
            return false;
        }
        int n = 0;
        while (n < this.assertion.length) {
            if (!this.assertion[n].a(rDN.assertion[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof RDN) {
            return this.a((RDN)object);
        }
        return false;
    }

    DerValue a(ObjectIdentifier objectIdentifier) {
        int n = 0;
        while (n < this.assertion.length) {
            if (this.assertion[n].a.equals(objectIdentifier)) {
                return this.assertion[n].b;
            }
            ++n;
        }
        return null;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.assertion.length) {
            if (this.assertion[n3].b != null) {
                n += this.assertion[n3].b.length() * n2++;
            }
            ++n3;
        }
        return n;
    }

    public String toString() {
        String string = null;
        int n = 0;
        while (n < this.assertion.length) {
            string = string == null ? this.assertion[n].toString() : String.valueOf(string) + " + " + this.assertion[n];
            ++n;
        }
        return string;
    }
}

