/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.DerInputBuffer;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerOutputStream;
import java.io.IOException;
import java.io.Serializable;

final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private int[] a;
    private int b;
    private static final int c = 5;

    ObjectIdentifier(DerInputBuffer derInputBuffer) throws IOException {
        this.a(new DerInputStream(derInputBuffer), 0);
    }

    public ObjectIdentifier(DerInputStream derInputStream) throws IOException {
        byte by = (byte)derInputStream.a();
        if (by != 6) {
            throw new IOException("X509.ObjectIdentifier() -- data isn't an object ID (tag = " + by + ")");
        }
        int n = derInputStream.available() - derInputStream.b() - 1;
        if (n < 0) {
            throw new IOException("X509.ObjectIdentifier() -- not enough data");
        }
        this.a(derInputStream, n);
    }

    public ObjectIdentifier(String string) {
        int n = 46;
        int n2 = 0;
        int n3 = 0;
        this.b = 0;
        while ((n3 = string.indexOf(n, n2)) != -1) {
            n2 = n3 + 1;
            ++this.b;
        }
        ++this.b;
        this.a = new int[this.b];
        n2 = 0;
        int n4 = 0;
        String string2 = null;
        while ((n3 = string.indexOf(n, n2)) != -1) {
            string2 = string.substring(n2, n3);
            this.a[n4++] = Integer.valueOf(string2);
            n2 = n3 + 1;
        }
        string2 = string.substring(n2);
        this.a[n4] = Integer.valueOf(string2);
    }

    public ObjectIdentifier(int[] nArray) {
        try {
            this.a = (int[])nArray.clone();
            this.b = nArray.length;
        }
        catch (Throwable throwable) {
            System.out.println("X509.ObjectIdentifier(), no cloning!");
        }
    }

    void a(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(this.a[0] * 40 + this.a[1]);
        int n = 2;
        while (n < this.b) {
            ObjectIdentifier.a(derOutputStream2, this.a[n]);
            ++n;
        }
        derOutputStream.write((byte)6, derOutputStream2);
    }

    public boolean equals(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == this) {
            return true;
        }
        if (this.b != objectIdentifier.b) {
            return false;
        }
        int n = 0;
        while (n < this.b) {
            if (this.a[n] != objectIdentifier.a[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)object);
        }
        return false;
    }

    private static int a(DerInputStream derInputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n < 4) {
            n2 <<= 7;
            int n3 = derInputStream.a();
            n2 |= n3 & 0x7F;
            if ((n3 & 0x80) == 0) {
                return n2;
            }
            ++n;
        }
        throw new IOException("X509.OID, component value too big");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void a(DerInputStream derInputStream, int n) throws IOException {
        boolean bl = true;
        this.a = new int[5];
        this.b = 0;
        while (derInputStream.available() > n) {
            int n2 = ObjectIdentifier.a(derInputStream);
            if (bl) {
                int n3 = n2 < 40 ? 0 : (n2 < 80 ? 1 : 2);
                int n4 = n2 - n3 * 40;
                this.a[0] = n3;
                this.a[1] = n4;
                this.b = 2;
                bl = false;
                continue;
            }
            if (this.b >= this.a.length) {
                int[] nArray = new int[this.a.length + 5];
                System.arraycopy(this.a, 0, nArray, 0, this.a.length);
                this.a = nArray;
            }
            this.a[this.b++] = n2;
        }
        if (derInputStream.available() != n) {
            throw new IOException("X509.ObjectIdentifier() -- malformed input data");
        }
    }

    public boolean precedes(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier == this || this.b < objectIdentifier.b) {
            return false;
        }
        if (objectIdentifier.b < this.b) {
            return true;
        }
        int n = 0;
        while (n < this.b) {
            if (objectIdentifier.a[n] < this.a[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void a(DerOutputStream derOutputStream, int n) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            byArray[n2] = (byte)(n & 0x7F);
            if ((n >>>= 7) == 0) break;
            ++n2;
        }
        while (n2 > 0) {
            derOutputStream.write(byArray[n2] | 0x80);
            --n2;
        }
        derOutputStream.write(byArray[0]);
    }

    public String toString() {
        int n = 0;
        String string = "";
        while (n < this.b) {
            if (n != 0) {
                string = String.valueOf(string) + ".";
            }
            string = String.valueOf(string) + this.a[n];
            ++n;
        }
        return string;
    }
}

