/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.SSLInputStream;
import com.sun.net.ssl.internal.ssl.SSLOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;

final class ClientDiffieHellmanPublic
extends HandshakeMessage {
    private byte[] a;

    ClientDiffieHellmanPublic() {
        this.a = null;
    }

    ClientDiffieHellmanPublic(SSLInputStream sSLInputStream) throws IOException {
        this.a = sSLInputStream.a();
    }

    ClientDiffieHellmanPublic(BigInteger bigInteger) {
        this.a = bigInteger.toByteArray();
    }

    public BigInteger getClientPublicKey() {
        return new BigInteger(1, this.a);
    }

    protected int messageLength() {
        if (this.a == null) {
            return 0;
        }
        return this.a.length + 2;
    }

    protected int messageType() {
        return 16;
    }

    void a(PrintStream printStream) throws IOException {
        printStream.println("*** ClientDiffieHellmanPublic");
        if (HandshakeMessage.k != null && Debug.isOn("verbose")) {
            printStream.print("DH Public key = { ");
            if (this.a == null) {
                printStream.print("<implicit in client cert>");
            } else {
                int n = 0;
                while (n < this.a.length) {
                    if (n != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.a[n] & 0xFF);
                    ++n;
                }
            }
            printStream.println(" }");
        }
    }

    protected void send(SSLOutputStream sSLOutputStream) throws IOException {
        sSLOutputStream.a(this.a);
    }
}

