/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice.server;

import org.jboss.axis.MessageContext;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ParameterDesc;
import org.jboss.axis.description.ServiceDesc;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.providers.java.RPCInvocation;
import org.jboss.axis.providers.java.RPCProvider;
import org.jboss.logging.Logger;
import org.jboss.webservice.PortComponentInfo;
import org.jboss.webservice.deployment.OperationDescription;
import org.jboss.webservice.deployment.ServiceDescription;

import javax.xml.namespace.QName;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class JBossRPCInvocation extends RPCInvocation
{
   private Logger log = Logger.getLogger(JBossRPCInvocation.class);

   public JBossRPCInvocation(RPCProvider rpcProvider, MessageContext messageContext, SOAPEnvelopeAxisImpl soapEnvelopeDirty, SOAPEnvelopeAxisImpl soapEnvelopeDirty1, Object o)
   {
      super(rpcProvider, messageContext, soapEnvelopeDirty, soapEnvelopeDirty1, o);
   }

   public JBossRPCInvocation(RPCInvocation rpcInvocation)
   {
      super(rpcInvocation);
   }

   public OperationDesc getOperation(ServiceDesc serviceDesc, QName qname)
   {
      OperationDesc op = null;
      op = serviceDesc.getOperationByElementQName(qname);

      RPCProvider provider = getProvider();

      if (provider instanceof InvokerProvider)
      {
         PortComponentInfo pcInfo = ((InvokerProvider)provider).getPortComponentInfo();
         ServiceDescription svcDesc = pcInfo.getServiceDescription();
         OperationDescription custOp = svcDesc.getOperationByQName(qname);
         if (custOp != null)
         {
            String opName = custOp.getJavaName();
            QName returnName = custOp.getReturnQName();
            QName returnType = custOp.getReturnType();

            op.setName(opName);
            op.setReturnQName(returnName);
            op.setReturnType(returnType);

            // set parameters if there are any
            Iterator itr = custOp.getParameters();
            ArrayList paramList = new ArrayList();

            while (itr.hasNext())
            {
               OperationDescription.Parameter param = (OperationDescription.Parameter)itr.next();
               // no namespace uri for param name
               QName paramName = new QName("", param.getName());
               QName paramType = param.getType();
               String mode = param.getMode();
               ParameterDesc paramDesc = new ParameterDesc(paramName, convertMode(mode), paramType, null, false, false);
               paramList.add(paramDesc);
            }

            if (paramList.size() > 0)
            {
               op.setParameters(paramList);
            }
            // no faults in Operation currently
         }
      }

      return op;
   }

   private byte convertMode(String mode)
   {
      if ("INOUT".equals(mode))
      {
         return ParameterDesc.INOUT;
      }
      else if ("OUT".equals(mode))
      {
         return ParameterDesc.OUT;
      }
      else
      {
         return ParameterDesc.IN;
      }
   }

}
