/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice.server;

// $Id$

import org.jboss.axis.MessageContext;
import org.jboss.logging.Logger;

import java.lang.reflect.Method;

/**
 * An Axis RPC provider for JMX endpoints.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 30-Sep-2004
 */
public class InvokerProviderJMX extends InvokerProviderJSE
{
   /** @since 4.0.2 */
   static final long serialVersionUID = 7507097707486824402L;
   // provide logging
   private Logger log = Logger.getLogger(InvokerProviderJMX.class);

   /**
    * This method encapsulates the method invocation.
    *
    * @param msgContext MessageContext
    * @param method     the target method.
    * @param obj        the target object
    * @param argValues  the method arguments
    */
   protected Object invokeServiceEndpoint(MessageContext msgContext, Method method, Object obj, Object[] argValues)
           throws Exception
   {
      log.debug("Invoke JMX: " + method);

      // invoke the bean method
      Object retObj = null;
      return retObj;
   }
}
