/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice.encoding.ser;

// $Id$

import org.jboss.axis.encoding.Serializer;
import org.jboss.axis.encoding.ser.BaseSerializerFactory;
import org.jboss.webservice.deployment.BeanXMLMetaData;

import javax.xml.namespace.QName;

/** A factory for the MetaDataBeanSerializer
 *
 * @author thomas.diesler@jboss.org
 */
public class MetaDataBeanSerializerFactory extends BaseSerializerFactory
{
   /** @since 4.0.2 */
   static final long serialVersionUID = 2678054736500907260L;

   private BeanXMLMetaData metaData;

   public MetaDataBeanSerializerFactory(Class javaType, QName xmlType)
   {
      super(MetaDataBeanSerializer.class, xmlType, javaType);
   }

   public void setMetaData(BeanXMLMetaData metaData)
   {
      this.metaData = metaData;
   }

   protected Serializer getSpecialized(String mechanismType)
   {
      return new MetaDataBeanSerializer(javaType, xmlType, metaData);
   }

   protected Serializer getGeneralPurpose(String mechanismType)
   {
      return new MetaDataBeanSerializer(javaType, xmlType, metaData);
   }
}
