/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice.deployment;

// $Id$

import org.jboss.logging.Logger;

import javax.xml.namespace.QName;
import java.util.HashMap;

/**
 * A registry that holds typeMapping child elements.
 * <p/>
 * For example the ws4ee-deployment.xml may contain a typeMapping like this, then
 * the <typeDesc> element will be registered under the qname {http://MarshallTest.org/xsd}AllStruct
 * <p/>
 * <typeMapping
 *    qname='ns1:AllStruct' xmlns:ns1='http://MarshallTest.org/xsd'
 *    type='java:org.jboss.ws4ee.test.marshalltest.rpcenc.AllStruct'
 *    serializer='org.jboss.ws4ee.test.marshalltest.rpcenc.ser.AllStructSerializerFactory'
 *    deserializer='org.jboss.ws4ee.test.marshalltest.rpcenc.ser.AllStructDeserializerFactory'
 *    encodingStyle='http://schemas.xmlsoap.org/soap/encoding/'>
 *    <typeDesc >
 *       <elementDesc fieldName="varBase64Binary" xmlName="varBase64Binary" xmlType="xsd:base64Binary"/>
 *       <elementDesc fieldName="varHexBinary" xmlName="varHexBinary" xmlType="xsd:hexBinary"/>
 *       <elementDesc fieldName="varSoapString" xmlName="varSoapString" xmlType="soapenc:string"/>
 *       <elementDesc fieldName="varSoapBoolean" xmlName="varSoapBoolean" xmlType="soapenc:boolean"/>
 *       <elementDesc fieldName="varSoapFloat" xmlName="varSoapFloat" xmlType="soapenc:float"/>
 *       <elementDesc fieldName="varSoapDouble" xmlName="varSoapDouble" xmlType="soapenc:double"/>
 *       <elementDesc fieldName="varSoapDecimal" xmlName="varSoapDecimal" xmlType="soapenc:decimal"/>
 *       <elementDesc fieldName="varSoapInt" xmlName="varSoapInt" xmlType="soapenc:int"/>
 *       <elementDesc fieldName="varSoapShort" xmlName="varSoapShort" xmlType="soapenc:short"/>
 *       <elementDesc fieldName="varSoapByte" xmlName="varSoapByte" xmlType="soapenc:byte"/>
 *       <elementDesc fieldName="varSoapBase64" xmlName="varSoapBase64" xmlType="soapenc:base64"/>
 *    </typeDesc>
 * </typeMapping>
 *
 * @author thomas.diesler@jboss.org
 * @since 08-June-2004
 */
public class MetaDataRegistry
{
   // provide logging
   private final Logger log = Logger.getLogger(MetaDataRegistry.class);

   private HashMap typeMappingMetaData = new HashMap();

   public void registerTypeMappingMetaData(TypeMappingDescription typeMapping)
   {
      QName qname = typeMapping.getTypeQName();
      BeanXMLMetaData metaData = typeMapping.getMetaData();
      if (metaData == null)
         throw new IllegalArgumentException("Cannot register null meta data");

      if (isTypeMappingMetaDataRegisterd(qname) == false || typeMapping.isUserDefined())
      {
         log.debug("Register type mapping meta data for: " + qname);
         typeMappingMetaData.put(qname, metaData);
      }
      else
      {
         log.debug("Ignore register type mapping meta data for: " + qname);
      }
   }

   public BeanXMLMetaData getTypeMappingMetaData(QName typeName)
   {
      return (BeanXMLMetaData)typeMappingMetaData.get(typeName);
   }

   public boolean isTypeMappingMetaDataRegisterd(QName typeName)
   {
      return typeMappingMetaData.get(typeName) != null;
   }

   public void unregisterTypeMappingMetaData(QName typeName)
   {
      typeMappingMetaData.remove(typeName);
   }
}
