/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice;

// $Id$

import javax.xml.namespace.QName;

/**
 * Constants for JBoss ws4ee webservices.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 27-April-2004
 */
public interface Constants
{
   /** The default WS4EE namespace uri */
   String NAMESPACE = "http://webservice.jboss.com/ws4ee";
   /** The Axis client engine config system property: org.jboss.ws4ee.client.config */
   String CLIENT_CONFIG = "org.jboss.ws4ee.client.config";
   /** The Axis server engine config system property: org.jboss.ws4ee.server.config */
   String SERVER_CONFIG = "org.jboss.ws4ee.server.config";
   
   // The property name of the handler chain in the message context
   String HANDLER_CHAIN = new QName(NAMESPACE, "HANDLER_CHAIN").toString();
   // The property name of the last fault in the message context
   String LAST_FAULT = new QName(NAMESPACE, "LAST_FAULT").toString();
}
