/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice;

/**
 * MBean interface.
 * @since 15-April-2004
 */
public interface AxisServiceMBean extends org.jboss.system.ServiceMBean
{

   //default object name
   public static final javax.management.ObjectName OBJECT_NAME = org.jboss.mx.util.ObjectNameFactory
         .create("jboss.ws4ee:service=AxisService");

   java.lang.String getWebServiceHost();

   int getWebServicePort();

   int getWebServiceSecurePort();

   boolean isAlwaysModifySOAPAddress();

   void setWebServiceHost(java.lang.String host);

   void setWebServicePort(int port);

   void setWebServiceSecurePort(int port);

   void setAlwaysModifySOAPAddress(boolean modify);

   java.lang.String getInvokerProviderEJB();

   void setInvokerProviderEJB(java.lang.String invokerProviderEJB);

   java.lang.String getInvokerProviderJSE();

   void setInvokerProviderJSE(java.lang.String invokerProviderJSE);

   /**
    * Get axis server singleton
    */
   org.jboss.axis.server.AxisServer getAxisServer();

   /**
    * Get MetaDataBeanSerializer/Deserializer metaData registry
    */
   org.jboss.webservice.deployment.MetaDataRegistry getMetaDataRegistry();

   /**
    * Get port component info for a given web service id The keys into the registry are: [deploment.ear]/[deployment.?ar]#PortComponentName A client deployment may use a 'port-component-link' like: [deployment.?ar]#PortComponentName In case we don't find a direct match we try matching by key.endsWith(wsID) See CTS test: /com/sun/ts/tests/webservices/deploy/portcomplink
    * @param wsID The web service identifier
    * @return The port component info, or null
    */
   org.jboss.webservice.PortComponentInfo getPortComponentInfo(java.lang.String wsID);

   /**
    * Returns a the array of registered PortComponentInfo objects
    */
   org.jboss.webservice.PortComponentInfo[] listServiceEndpointInfos();

   /**
    * List the registered webservices
    */
   java.lang.String listServiceEndpoints();

   /**
    * Deploy a webservice from a Axis WSDD URL
    */
   void deployService(org.jboss.webservice.PortComponentInfo pcInfo) throws java.lang.Exception;

   /**
    * Undeploy a webservice for a given web service id
    */
   void undeployService(java.lang.String serviceID) throws java.lang.Exception;

}
