/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.varia.scheduler;

/**
 * MBean interface.
 */
public interface SchedulerMBean extends org.jboss.system.ServiceMBean
{

   //default object name
   public static final javax.management.ObjectName OBJECT_NAME = org.jboss.mx.util.ObjectNameFactory
         .create("jboss:service=Scheduler");

   /**
    * Starts the schedule if the schedule is stopped otherwise nothing will happen. The Schedule is immediately set to started even the first call is in the future.
    * @throws InvalidParameterException If any of the necessary values are not set or invalid (especially for the Schedulable class attributes).    */
   void startSchedule();

   /**
    * Stops the schedule because it is either not used anymore or to restart it with new values.
    * @param pDoItNow If true the schedule will be stopped without waiting for the next scheduled call otherwise the next call will be performed before the schedule is stopped.    */
   void stopSchedule(boolean pDoItNow);

   /**
    * Stops the server right now and starts it right now.
    */
   void restartSchedule();

   java.lang.String getSchedulableClass();

   /**
    * Sets the fully qualified Class name of the Schedulable Class being called by the Scheduler. Must be set before the Schedule is started. Please also set the {@link #setSchedulableArguments} and {@link #setSchedulableArgumentTypes}.
    * @param pSchedulableClass Fully Qualified Schedulable Class.
    * @throws InvalidParameterException If the given value is not a valid class or cannot be loaded by the Scheduler or is not of instance Schedulable.    */
   void setSchedulableClass(java.lang.String pSchedulableClass) throws java.security.InvalidParameterException;

   java.lang.String getSchedulableArguments();

   void setSchedulableArguments(java.lang.String pArgumentList);

   java.lang.String getSchedulableArgumentTypes();

   /**
    * Sets the comma seperated list of argument types for the Schedulable class. This will be used to find the right constructor and to created the right instances to call the constructor with. This list must have as many elements as the Schedulable Arguments list otherwise the start of the Scheduler will fail. Right now only basic data types, String and Classes with a Constructor with a String as only argument are supported.
    * @param pTypeList List of arguments used to create the Schedulable intance. If the list is null or empty then the no-args constructor is used.
    * @throws InvalidParameterException If the given list contains a unknow datat type.    */
   void setSchedulableArgumentTypes(java.lang.String pTypeList) throws java.security.InvalidParameterException;

   java.lang.String getSchedulableMBean();

   /**
    * Sets the fully qualified JMX MBean name of the Schedulable MBean to be called. <b>Attention: </b>if set the all values set by {@link #setSchedulableClass}, {@link #setSchedulableArguments} and {@link #setSchedulableArgumentTypes} are cleared and not used anymore. Therefore only use either Schedulable Class or Schedulable MBean. If {@link #setSchedulableMBeanMethod} is not set then the schedule method as in the {@link Schedulable#perform} will be called with the same arguments. Also note that the Object Name will not be checked if the MBean is available. If the MBean is not available it will not be called but the remaining repetitions will be decreased.
    * @param pSchedulableMBean JMX MBean Object Name which should be called.
    * @throws InvalidParameterException If the given value is an valid Object Name.    */
   void setSchedulableMBean(java.lang.String pSchedulableMBean) throws java.security.InvalidParameterException;

   /**
    * Sets the method name to be called on the Schedulable MBean. It can optionally be followed by an opening bracket, list of attributes (see below) and a closing bracket. The list of attributes can contain: <ul> <li>NOTIFICATION which will be replaced by the timers notification instance (javax.management.Notification)</li> <li>DATE which will be replaced by the date of the notification call (java.util.Date)</li> <li>REPETITIONS which will be replaced by the number of remaining repetitions (long)</li> <li>SCHEDULER_NAME which will be replaced by the Object Name of the Scheduler (javax.management.ObjectName)</li> <li>any full qualified Class name which the Scheduler will be set a "null" value for it</li> </ul> <br> An example could be: "doSomething( NOTIFICATION, REPETITIONS, java.lang.String )" where the Scheduler will pass the timer's notification instance, the remaining repetitions as int and a null to the MBean's doSomething() method which must have the following signature: doSomething( javax.management.Notification, long, java.lang.String ).
    * @param pSchedulableMBeanMethod Name of the method to be called optional followed by method arguments (see above).
    * @throws InvalidParameterException If the given value is not of the right format    */
   void setSchedulableMBeanMethod(java.lang.String pSchedulableMBeanMethod)
         throws java.security.InvalidParameterException;

   boolean isUsingMBean();

   long getSchedulePeriod();

   /**
    * Sets the Schedule Period between two scheduled call.
    * @param pPeriod Time between to scheduled calls (after the initial call) in Milliseconds. This value must be bigger than 0.
    * @throws InvalidParameterException If the given value is less or equal than 0    */
   void setSchedulePeriod(long pPeriod);

   java.lang.String getDateFormat();

   /**
    * Sets the date format used to parse date/times
    * @param dateFormat The date format when empty or null the locale is used to parse dates    */
   void setDateFormat(java.lang.String dateFormat);

   java.lang.String getInitialStartDate();

   /**
    * Sets the first scheduled call. If the date is in the past the scheduler tries to find the next available start date.
    * @param pStartDate Date when the initial call is scheduled. It can be either: <ul> <li> NOW: date will be the current date (new Date()) plus 1 seconds </li><li> Date as String able to be parsed by SimpleDateFormat with default format </li><li> Date as String parsed using the date format attribute </li><li> Milliseconds since 1/1/1970 </li> </ul> If the date is in the past the Scheduler will search a start date in the future with respect to the initial repe- titions and the period between calls. This means that when you restart the MBean (restarting JBoss etc.) it will start at the next scheduled time. When no start date is available in the future the Scheduler will not start.<br> Example: if you start your Schedulable everyday at Noon and you restart your JBoss server then it will start at the next Noon (the same if started before Noon or the next day if start after Noon).    */
   void setInitialStartDate(java.lang.String pStartDate);

   long getInitialRepetitions();

   /**
    * Sets the initial number of scheduled calls.
    * @param pNumberOfCalls Initial Number of scheduled calls. If -1 then the number is unlimted.
    * @throws InvalidParameterException If the given value is less or equal than 0    */
   void setInitialRepetitions(long pNumberOfCalls);

   long getRemainingRepetitions();

   boolean isStarted();

   boolean isRestartPending();

   boolean isStartAtStartup();

   /**
    * Set the scheduler to start when MBean started or not. Note that this method only affects when the {@link #startService startService()} gets called (normally at startup time.
    * @param pStartAtStartup True if Schedule has to be started at startup time    */
   void setStartAtStartup(boolean pStartAtStartup);

   boolean isActive();

   java.lang.String getTimerName();

   void setTimerName(java.lang.String pTimerName);

}
