/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.wsrp;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

import junit.framework.Test;

import org.jboss.test.webservice.WebserviceTestBase;
import org.jboss.test.wsrp.core.GetServiceDescription;
import org.jboss.test.wsrp.core.ServiceDescription;

/**
 * Tests WSRP Service Description
 *
 * @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 * @author <a href="mailto:chris.laprun@jboss.com">Chris Laprun</a>
 * @since 2.4 (Feb 20, 2006)
 */
public class ServiceDescriptionTestCase extends WebserviceTestBase
{
   public ServiceDescriptionTestCase(String name)
   {
      super(name);
   }

   /**
    * deploy the test archives
    */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ServiceDescriptionTestCase.class, "wsrp.war, wsrp-client.jar");
   }

   public void testGetServiceDescription() throws Exception
   {
      InitialContext iniCtx = getClientContext("wsrp-client");
      Service service = (Service)iniCtx.lookup("java:comp/env/service/ServiceDescriptionService");
      WSRP_v1_ServiceDescription_PortType endpoint =
         (WSRP_v1_ServiceDescription_PortType)service.getPort(WSRP_v1_ServiceDescription_PortType.class);
      GetServiceDescription gs = new GetServiceDescription();
      String[] locales = new String[]{};

      gs.setDesiredLocales(locales);

      //Invoke the Web Service
      ServiceDescription sd = endpoint.getServiceDescription(gs);
      assertNotNull("sd != null", sd);
   }

}
