package org.jboss.test.webservice.jbws663;

import org.jboss.logging.Logger;
import org.jboss.test.webservice.jbws663.holders.ResponseInfoHolder;
import org.jboss.test.webservice.jbws663.holders.SubscriptionInfoHolder;

/**
 * document/literal bare, headers bound to the endpoint  
 */
public class SMSTextMessagingSoapBareBoundImpl implements SMSTextMessagingSoapBareBound
{
   private Logger log = Logger.getLogger(SMSTextMessagingSoapBareBoundImpl.class);
   
   public SendMessageResponse sendMessage(SendMessage parameters, LicenseInfo licenseInfo, ResponseInfoHolder responseInfo, SubscriptionInfoHolder subscriptionInfo)
   {
      log.debug("sendMessage: " + parameters.getMessageText());
      MessageStatus msgStatus = new MessageStatus(100, "ok", licenseInfo.getRegisteredUser().getUserID());
      SMSTextMessageTargetStatus status = new SMSTextMessageTargetStatus(parameters.getToNumber(), "track001", msgStatus);
      SendMessageResponse retObj = new SendMessageResponse(status);

      //set the response headers
      responseInfo.value = new ResponseInfo(0, "all ok");
      subscriptionInfo.value = new SubscriptionInfo(0, "valid", 0, null, 0, null);
      
      return retObj;
   }

   public SendMessagesBulkResponse sendMessagesBulk(SendMessagesBulk parameters, LicenseInfo licenseInfo, ResponseInfoHolder responseInfo,
         SubscriptionInfoHolder subscriptionInfo)
   {
      SendMessagesBulkResponse retObj = null;
      return retObj;
   }

   public TrackMessageResponse trackMessage(TrackMessage parameters, LicenseInfo licenseInfo, ResponseInfoHolder responseInfo, SubscriptionInfoHolder subscriptionInfo)
   {

      TrackMessageResponse retObj = null;
      return retObj;
   }

   public TrackMessagesBulkResponse trackMessagesBulk(TrackMessagesBulk parameters, LicenseInfo licenseInfo, ResponseInfoHolder responseInfo,
         SubscriptionInfoHolder subscriptionInfo)
   {
      TrackMessagesBulkResponse retObj = null;
      return retObj;
   }

   public GetSupportedCarriersResponse getSupportedCarriers(GetSupportedCarriers parameters, LicenseInfo licenseInfo, SubscriptionInfoHolder subscriptionInfo)
   {
      GetSupportedCarriersResponse retObj = null;
      return retObj;
   }

   public GetCountryCodesResponse getCountryCodes(GetCountryCodes parameters, LicenseInfo licenseInfo, SubscriptionInfoHolder subscriptionInfo)
   {
      GetCountryCodesResponse retObj = null;
      return retObj;
   }

   public GetRemainingHitsResponse getRemainingHits(GetRemainingHits parameters, LicenseInfo licenseInfo, SubscriptionInfoHolder subscriptionInfo)
   {
      GetRemainingHitsResponse retObj = null;
      return retObj;
   }
}
