/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.webservice.jbws643;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

import junit.framework.Test;

import org.jboss.test.webservice.WebserviceTestBase;

/**
 * Enhanced guessing of bean properties in BeanDeserializer
 * 
 * http://jira.jboss.org/jira/browse/JBWS-643
 *
 * @author Thomas.Diesler@jboss.org
 * @since 27-Jan-2006
 */
public class JBWS643TestCase extends WebserviceTestBase
{
   private static ResearchService port;
   
   public JBWS643TestCase(String name)
   {
      super(name);
   }
   
   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS643TestCase.class, "ws4ee-jbws643.war, ws4ee-jbws643-client.jar");
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      if (port == null)
      {
         InitialContext iniCtx = getClientContext();
         Service service = (Service)iniCtx.lookup("java:comp/env/service/ResearchService");
         port = (ResearchService)service.getPort(ResearchService.class);
      }
   }

   public void testCreateService() throws Exception
   {
      assertNotNull("port not null", port);
   }
   
   public void testSendMessage() throws Exception
   {
      GetKeywordStatisticsRequest reqObj = new GetKeywordStatisticsRequest(new String[]{"key1","key2"}, "market", false);
      GetKeywordStatisticsResponse resObj = port.getKeywordStatistics(reqObj);
      assertNotNull("response not null", resObj);
   }
}
