/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.webservice.jbws464;

import java.rmi.RemoteException;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

import junit.framework.Test;

import org.jboss.test.webservice.WebserviceTestBase;

/**
 * SAAJ: SOAPEnvelope.getOwnerDocument() returns null
 * 
 * http://jira.jboss.com/jira/browse/JBWS-464
 * 
 * @author <a href="mailto:anil.saldhana@jboss.com">Anil Saldhana</a>
 * @since 24-Oct-2005
 */
public class JBWS464TestCase extends WebserviceTestBase
{
   private static Hello hello;

   public JBWS464TestCase(String name)
   {
      super(name);
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS464TestCase.class, "ws4ee-jbws464.war, ws4ee-jbws464-client.jar");
   }
   
   public void setUp() throws Exception
   {
      super.setUp();
      if (hello == null)
      {
         InitialContext iniCtx = getClientContext();
         Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
         hello = (Hello)service.getPort(Hello.class);
      }
   }
   
   public void testValidAccess() throws Exception
   {  
      String retObj = hello.hello("Hello Server");
      assertEquals("Hello Server", retObj); 
   }


   // This tests access from the SOAPFault message */ 
   public void testInvalidAccess() throws Exception
   {  
      try
      {
        hello.hello(null);
        fail("Test should have thrown an exception");
      }catch(RemoteException e)
      {
         //pass
      }
   } 
}
