/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.webservice.jbws425;

import java.io.ByteArrayInputStream;
import java.net.URL;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;

import junit.framework.Test;

import org.jboss.test.webservice.WebserviceTestBase;

/**
 * No SOAPAction when message is sent with SOAPConnection
 *
 * http://jira.jboss.com/jira/browse/JBWS-425
 *
 * @author Thomas.Diesler@jboss.org
 * @since 30-Nov-2005
 */
public class JBWS425TestCase extends WebserviceTestBase
{
   private static final String SOAP_ACTION = "\"urn:some-soap-action\"";

   private static Hello endpoint;

   public JBWS425TestCase(String name)
   {
      super(name);
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS425TestCase.class, "ws4ee-jbws425.war, ws4ee-jbws425-client.jar");
   }

   public void setUp() throws Exception
   {
      super.setUp();
      if (endpoint == null)
      {
         InitialContext iniCtx = getClientContext();
         Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
         endpoint = (Hello)service.getPort(Hello.class);
      }
   }

   public void testClientAccess() throws Exception
   {
      String soapAction = endpoint.hello("Hello Server");
      assertEquals(SOAP_ACTION, soapAction);
   }

   public void testMessageAccess() throws Exception
   {
      String reqEnv =
         "<soapenv:Envelope xmlns:soapenv='http://schemas.xmlsoap.org/soap/envelope/'>" +
         "  <soapenv:Body>" +
         "    <ns1:hello xmlns:ns1='http://org.jboss.test.webservice/jbws425'>" +
         "      <String_1>Hello Server</String_1>" +
         "    </ns1:hello>" +
         "  </soapenv:Body>" +
         "</soapenv:Envelope>";

      MessageFactory msgFactory = MessageFactory.newInstance();
      SOAPConnection con = SOAPConnectionFactory.newInstance().createConnection();

      MimeHeaders mimeHeaders = new MimeHeaders();
      mimeHeaders.addHeader("SOAPAction", SOAP_ACTION);

      SOAPMessage reqMsg = msgFactory.createMessage(mimeHeaders, new ByteArrayInputStream(reqEnv.getBytes()));

      URL epURL = new URL("http://" + getServerHost() + ":8080/ws4ee-jbws425");
      SOAPMessage resMsg = con.call(reqMsg, epURL);

      SOAPElement soapElement = (SOAPElement)resMsg.getSOAPBody().getChildElements().next();
      soapElement = (SOAPElement)soapElement.getChildElements().next();
      String soapAction = soapElement.getValue();
      assertEquals(SOAP_ACTION, soapAction);
   }

}
