/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.test.testbeancluster.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Tests the SingleRetryInterceptor.
 * 
 * @author <a href="mailto://brian.stansberry@jboss.com">Brian Stansberry</a>
 * @version $Revision$
 */
public class SingleRetryInterceptorUnitTestCase extends RetryInterceptorUnitTestCase
{
   /**
    * Create a new SingleRetryInterceptorUnitTestCase.
    * 
    * @param name
    */
   public SingleRetryInterceptorUnitTestCase(String name)
   {
      super(name);
   }  


   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(SingleRetryInterceptorUnitTestCase.class));

      // Create an initializer for the test suite
      DBSetup wrapper = new DBSetup(suite);
      return wrapper;
   }
   

   /**
    * Override the superclass to not expect recovery.
    */
   public void testDeferredRecovery() throws Exception
   {
      deferredRecoveryTest(false);
      }
      
   protected String getJndiSuffix()
   {
      return "_SingleRetry";
   }
   
   }
   
