package org.jboss.test.security.ejb;

import org.apache.log4j.Category;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.CreateException;
import java.security.Principal;

/** A simple session bean that is used to test the 

 @author Scott.Stark@jboss.org
 @version $Revision$
 */
public class MissingMethodBean implements SessionBean
{
   private static Category log = Category.getInstance(MissingMethodBean.class);
   private SessionContext sessionContext;

   public void ejbCreate() throws CreateException
   {
      MissingMethodBean.log.debug("ejbCreate() called");
   }

   public void ejbActivate()
   {
      MissingMethodBean.log.debug("ejbActivate() called");
   }

   public void ejbPassivate()
   {
      MissingMethodBean.log.debug("ejbPassivate() called");
   }

   public void ejbRemove()
   {
      MissingMethodBean.log.debug("ejbRemove() called");
   }

   public void setSessionContext(SessionContext context)
   {
      sessionContext = context;
   }

   public String invokeEcho(String arg)
   {
      log.debug("invokeEcho, arg="+arg);
      Principal p = sessionContext.getCallerPrincipal();
      log.debug("echo, callerPrincipal="+p);
      boolean isCaller = sessionContext.isCallerInRole("EchoCaller");
      log.debug("echo, isCallerInRole('EchoCaller')="+isCaller);
      isCaller = sessionContext.isCallerInRole("InternalRole");
      log.debug("echo, isCallerInRole('InternalRole')="+isCaller);
      return arg;
   }

   public void callEcho()
   {
      log.debug("callEcho");
   }

   public void noop()
   {
      log.debug("noop");
   }
}
