/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.security.ejb;

import java.io.IOException;
import java.security.Principal;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import org.apache.log4j.Logger;

/** A simple session bean for testing custom security.

 @author Scott.Stark@jboss.org
 @version $Revision$
 */
public class IOStatefulSessionBean implements SessionBean
{
   static Logger log = Logger.getLogger(IOStatefulSessionBean.class);

   private SessionContext sessionContext;
   private String sessionPath;

   public void ejbCreate() throws CreateException
   {
      log.debug("ejbCreate() called");
   }

   public void ejbActivate()
   {
      log.debug("ejbActivate() called");
   }

   public void ejbPassivate()
   {
      log.debug("ejbPassivate() called");
   }

   public void ejbRemove()
   {
      log.debug("ejbRemove() called");
   }

   public void setSessionContext(SessionContext context)
   {
      sessionContext = context;
   }

   public void setPath(String path)
   {
      this.sessionPath = path;
   }

   public String retryableRead(String path) throws IOException
   {
      return read(path);
   }

   public String read(String path) throws IOException
   {
      log.debug("read, path=" + path);
      Principal p = sessionContext.getCallerPrincipal();
      log.debug("read, callerPrincipal=" + p);
      return path;
   }

   public void write(String path) throws IOException
   {
      log.debug("write, path=" + path);
      Principal p = sessionContext.getCallerPrincipal();
      log.debug("write, callerPrincipal=" + p);
   }
}
