/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.jca.test;

import javax.resource.cci.Connection;

/**
 * Uncontended pooling stress test.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision$
 */
public class UncontendedInterleavingStressTestCase extends AbstractUncontendedPoolingStressTest
{
   public void testIt() throws Throwable
   {
      tm.setTransactionTimeout(0);
      UncontendedPoolingRunnable[] runnables = new UncontendedPoolingRunnable[getThreadCount()];
      for (int i = 0; i < runnables.length; ++i)
      {
         runnables[i] = new UncontendedPoolingRunnable()
         {
            public void doRun() throws Throwable
            {
               Connection c = cf.getConnection();
               c.close();
            }
         };
      }

      runConcurrentTest(runnables, null);
   }
   
   public UncontendedInterleavingStressTestCase(String name)
   {
      super(name);
   }
}
