/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.jca.test;

import javax.resource.cci.Connection;

/**
 * Uncontended pooling stress test.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision$
 */
public class RecyclingStickyWithContinuousPoisonThreadStressTestCase extends AbstractRecyclingPoolingStressTest
{
   public boolean isSticky()
   {
      return true;
   }

   public void testIt() throws Throwable
   {
      tm.setTransactionTimeout(0);
      RecyclingPoolingRunnable[] runnables = new RecyclingPoolingRunnable[getThreadCount()];
      runnables[0] = new RecyclingPoolingRunnable()
      {
         public void doStart() throws Throwable
         {
            tm.begin();
            tm.setRollbackOnly();
         }
         
         public void doRun() throws Throwable
         {
            doRun1();
         }
            
         public void doEnd() throws Throwable
         {
            tm.rollback();
         }

         public void doRun1() throws Throwable
         {
            boolean thrown = false;
            try
            {
               cf.getConnection();
            }
            catch (Throwable expected)
            {
               thrown = true;
            }
            if (thrown == false)
               throw new Exception("Expected exception for rolled back tx");
         }
      };
      for (int i = 1; i < runnables.length; ++i)
      {
         runnables[i] = new RecyclingPoolingRunnable()
         {
            public void doRun1() throws Throwable
            {
               Connection c = cf.getConnection();
               c.close();
            }
         };
      }

      runConcurrentTest(runnables, null);
   }
   
   public RecyclingStickyWithContinuousPoisonThreadStressTestCase(String name)
   {
      super(name);
   }
}
