/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.jca.test;

import javax.transaction.Transaction;

/**
 * Abstract contentious pooling stress test.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision$
 */
public class AbstractUncontendedPoolingStressTest extends AbstractPoolingStressTest
{
   
   public abstract class UncontendedPoolingRunnable extends ConcurrentRunnable
   {
      protected Transaction tx;
      public UncontendedPoolingRunnable()
      {
      }

      public void doStart() throws Throwable
      {
         tm.begin();
      }

      public void doEnd() throws Throwable
      {
         tm.commit();
      }
   }

   
   public AbstractUncontendedPoolingStressTest(String name)
   {
      super(name);
   }
}
