/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.jacc.test;

import javax.security.auth.login.Configuration;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.extensions.TestSetup;
import org.jboss.test.JBossTestSetup;
import org.jboss.security.auth.login.XMLLoginConfigImpl;

/** Test of EJB spec conformace using the security-spec.jar
 deployment unit when running under a JACC authorization manager.

@author Scott.Stark@jboss.org
@version $Revision$
 */
public class EJBSpecUnitTestCase
   extends org.jboss.test.security.test.EJBSpecUnitTestCase
{

   public EJBSpecUnitTestCase(String name)
   {
      super(name);
   }

   /**
    * @todo this fails under JACC because there is no automatic granting
    * of the correct create permissions needed for the handle activation. This
    * is due to the implementation detail of the handle calling back into
    * the container on activation.
    */ 
   public void testStatefulHandle()
   {  
   }
   
   /**
    * Needs to be overriden because for JACC, the role "Role2"
    * is not defined as a security-role-ref
    */
   public void testDomainInteraction()
   {
   }

   /**
    * Setup the test suite.
    */
   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(EJBSpecUnitTestCase.class));

      // Create an initializer for the test suite
      TestSetup wrapper = new JBossTestSetup(suite)
      {
         protected void setUp() throws Exception
         {
            super.setUp();
            Configuration.setConfiguration(new XMLLoginConfigImpl());
            redeploy("security-spec.jar");
            flushAuthCache();
         }
         protected void tearDown() throws Exception
         {
            undeploy("security-spec.jar");
            super.tearDown();
         
         }
      };
      return wrapper;
   }

}
