/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.entity.interfaces;

import java.rmi.RemoteException;
import javax.ejb.EJBObject;

/**
 * Session facade for entity testing.
 *
 * @author    Adrian.Brock@HappeningTimes.com
 * @version   $Revision$
 */
public interface EntitySession
   extends EJBObject
{
   public void createPathological(String name, boolean pathological)
      throws RemoteException;

   public void removeHomePathological(String name, boolean pathological)
      throws RemoteException;

   public void removePathological(String name, boolean pathological)
      throws RemoteException;

   public void findPathological(String name, boolean pathological)
      throws RemoteException;

   public void getPathological(String name, boolean pathological)
      throws RemoteException;

   public void setPathological(String name, boolean pathological)
      throws RemoteException;
}
