/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.cmp2.dbschema.util;

import net.sourceforge.junitejb.EJBTestCase;

import javax.sql.DataSource;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.sql.Connection;
import java.sql.SQLException;


/**
 *
 * @author <a href="mailto:alex@jboss.org">Alex Loubyansky</a>
 */
public class AbstractDBSchemaTest
   extends EJBTestCase
{
   protected String datasourceName = "java:/DefaultDS";
   protected DataSource datasource;

   public AbstractDBSchemaTest(String s)
   {
      super(s);
   }

   protected Connection getConnection()
      throws NamingException, SQLException
   {
      return getDataSource().getConnection();
   }

   protected DataSource getDataSource() throws NamingException
   {
      if(datasource == null)
      {
         datasource = getDataSource(datasourceName);
      }
      return datasource;
   }

   protected DataSource getDataSource(String datasource) throws NamingException
   {
      InitialContext ic = null;
      try
      {
         ic = new InitialContext();
         return (DataSource)ic.lookup(datasource);
      }
      finally
      {
         if(ic != null)
            try
            {
               ic.close();
            }
            catch(Exception ignore){}
      }
   }
}
