package org.jboss.test.cluster.web.jk.test;

import java.io.IOException;
import java.net.HttpURLConnection;

import junit.framework.Test;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.test.JBossClusteredTestCase;
import org.jboss.test.cluster.test.BaseTest;

public class JvmRouteURLRewritingTestCase extends BaseTest
{

   public JvmRouteURLRewritingTestCase(String name)
   {
      super(name);
   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(JvmRouteURLRewritingTestCase.class,
            "http-jk.war");
      return t1;
   }
   
   public void testJkFailoverWithURLRewriting() throws Exception
   {
      getLog().debug("Enter testJkFailoverWithURLRewriting()");
      
      // Create an instance of HttpClient.
      HttpClient client = new HttpClient();
      
      String sessId0 = makeGetWithRequestCount(client, baseURL0_, null, "1");
      
      // Fail over to node1
      String sessId1 = makeGetWithRequestCount(client, baseURL1_, sessId0, "2");
      
      // Fail back over to node0
      makeGetWithRequestCount(client, baseURL0_, sessId1, "3");
   }
   
   private String makeGetWithRequestCount(HttpClient client, 
                                          String urlBase,
                                          String sessionId,
                                          String expectedCount)
   {
      String url = urlBase + "/http-jk/accessSession.jsp";
      if (sessionId != null)
      {
         url = url + ";jsessionid=" + sessionId;
      }
      
      GetMethod method = new GetMethod(url);
      int responseCode = 0;
      try
      {
         responseCode = client.executeMethod(method);
      } 
      catch (IOException e)
      {
         e.printStackTrace();
         fail("HttpClient executeMethod fails." +e.toString());
      }
      assertTrue("Get OK with url: " +url + " responseCode: " +responseCode
        , responseCode == HttpURLConnection.HTTP_OK);      
      
      // Validate that the request count is as expected,
      // proving that state replication happened
      Header hdr = method.getResponseHeader("X-TestRequestCount");
      assertNotNull("Got the X-TestRequestCount header", hdr);
      assertEquals("X-TestRequestCount header is correct", expectedCount, hdr.getValue());
      
      // Find out the session id
      hdr = method.getResponseHeader("X-TestJSessionID");
      assertNotNull("Got the X-TestJSessionID header", hdr);      
      String id = hdr.getValue();
      
      if (sessionId != null)
      {
         // Check the real session id is correct
         assertEquals("Real session id is correct", stripJvmRoute(sessionId), 
                                                    stripJvmRoute(id));
         // Check the session id has changed
         assertFalse("Session id has changed", sessionId.equals(id));
      }
      
      // Read the response body and confirm the URL was properly encoded.
      byte[] responseBody = method.getResponseBody();
      String body = new String(responseBody);      
      String expectedURL = "accessSession.jsp;jsessionid=" + id;
      assertTrue("URL encoded properly: " + body, body.indexOf(expectedURL) > -1);
      
      return id;
   }

}
