package org.jboss.test.cluster.test;

import junit.framework.Test;

import org.jboss.test.JBossClusteredTestCase;

/**
 * Tests that a clustered session still functions properly on the second
 * node after the webapp is undeployed from the first node.
 * <p/>
 * This version tests a FieldBasedClusteredSession.
 * 
 * @author Brian Stansberry
 * @version $Id$
 */
public class UndeployFieldTestCase extends UndeployTestCase
{

   public UndeployFieldTestCase(String name)
   {
      super(name);
   }
   
   protected String getContextPath()
   {
      return "/http-scoped-field/";
   }
   
   protected String getWarName()
   {
      return "http-scoped-field.war";
   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(UndeployFieldTestCase.class,
            "http-scoped-field.war");
      return t1;
   }

}
