/* *************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ************************************* */
package org.jboss.test.aop.scoped.ear.servlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jboss.test.aop.scoped.ear.ejb.ExampleSession;
import org.jboss.test.aop.scoped.ear.ejb.ExampleSessionHome;
import org.jboss.test.aop.scoped.ear.interceptor.TestInterceptor;

/** 
 *  
 * @author <a href="mailto:kabirkhan@bigfoot.com">Kabir Khan</a>
 *
 */
public class EarExampleServlet extends HttpServlet {

   String scope;
   public void init(ServletConfig cfg) throws ServletException
   {
      super.init(cfg);
      scope = super.getInitParameter("scope");
   }

   public void service(HttpServletRequest request, HttpServletResponse response)
         throws ServletException, IOException {
      try 
      {
         InitialContext ctx = new InitialContext();
         Object obj = ctx.lookup("ExampleSession" + scope);
         
         System.out.println("Expected loader " + ExampleSessionHome.class.getClassLoader());
         System.out.println("Interfaces");
         Class[] ifs = obj.getClass().getInterfaces();
         for (int i = 0 ; i < ifs.length ; i++)
         {
            System.out.println(i + " " + ifs[i].getName() + " " + ifs[i].getClassLoader());
         }
         
         ExampleSessionHome home = (ExampleSessionHome)PortableRemoteObject.narrow(obj, ExampleSessionHome.class);
         ExampleSession exSess = home.create();
         
         String expected = "scope" + scope;
         String actual = TestInterceptor.scope;
         if (!actual.equals(expected))
         {
            throw new ServletException("Wrong TestInterceptor.scope, expected=" + expected + "; actual=" + TestInterceptor.scope);
         }
         
         TestInterceptor.intercepted = 0;
         exSess.getValue("hello"); 
         if (TestInterceptor.intercepted != 1)
         {
            throw new ServletException("Wrong TestInterceptor.intercepted for bean, expected=1; actual=" + TestInterceptor.intercepted);
         }

         TestInterceptor.intercepted = 0;
         testServlet();
         if (TestInterceptor.intercepted != 1)
         {
            throw new ServletException("Wrong TestInterceptor.intercepted for servlet, expected=1; actual=" + TestInterceptor.intercepted);
         }
//            throw new ServletException("Failed to call OptimizedEJB/Session30 through remote and local interfaces", e);

         response.setContentType("text/html");
         PrintWriter out = response.getWriter();
         out.println("<html>");
         out.println("<head><title>EarExampleServlet</title></head>");
         out.println("<body>Tests passed<br></body>");
         out.println("</html>");
         out.close();

      } 
      catch (Exception e) 
      {
         e.printStackTrace();
         throw new ServletException(e);
      } 
   }
   
   private void testServlet()
   {
      
   }
}
