/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.spring.factory;

import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.BeansException;
import org.springframework.core.io.Resource;

/**
 * @author <a href="mailto:ales.justin@genera-lynx.com">Ales Justin</a>
 */
public class NamedXmlBeanFactory extends DefaultListableBeanFactory implements Nameable {

    private String defaultName;
    private final NamedXmlBeanDefinitionReader reader = new NamedXmlBeanDefinitionReader(this);

    /**
     * @see org.springframework.beans.factory.xml.XmlBeanFactory
     */
    public NamedXmlBeanFactory(String defaultName, Resource resource) throws BeansException {
        this.reader.loadBeanDefinitions(resource);
        this.defaultName = defaultName;
    }

    public String getName() {
        String name = reader.getName() != null ? reader.getName() : defaultName;
        if (name == null) {
            throw new IllegalArgumentException("Bean factory JNDI name must be set!");
        }
        return name;
    }

}
