/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.spring.factory;

import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.BeansException;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;

/**
 * @author <a href="mailto:ales.justin@genera-lynx.com">Ales Justin</a>
 */
public class NamedXmlBeanDefinitionReader extends XmlBeanDefinitionReader implements Nameable {

    private NamedXmlBeanDefinitionParser parser;

    public NamedXmlBeanDefinitionReader(BeanDefinitionRegistry beanFactory) {
        super(beanFactory);
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalArgumentException("BeanFactory must implement ConfigurableBeanFactory!");
        }
        parser = new NamedXmlBeanDefinitionParser((ConfigurableBeanFactory) beanFactory);
    }

    public int registerBeanDefinitions(Document doc, Resource resource) throws BeansException {
        return parser.registerBeanDefinitions(this, doc, resource);
    }

    public String getName() {
        return parser.getName();
    }

}
