/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ejb.plugins.cmp.jdbc;

import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQlQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;

/**
 * This class generates a query from EJB-QL.
 *
 * @author <a href="mailto:dain@daingroup.com">Dain Sundstrom</a>
 * @author <a href="mailto:alex@jboss.org">Alex Loubyansky</a>
 * @version $Revision$
 */
public final class JDBCEJBQLQuery extends JDBCAbstractQueryCommand
{

   public JDBCEJBQLQuery(JDBCStoreManager manager,
                         JDBCQueryMetaData q)
      throws DeploymentException
   {
      super(manager, q);

      JDBCQlQueryMetaData metadata = (JDBCQlQueryMetaData) q;
      if(getLog().isDebugEnabled())
      {
         getLog().debug("EJB-QL: " + metadata.getEjbQl());
      }

      QLCompiler compiler = JDBCQueryManager.getInstance(metadata.getQLCompilerClass(), manager.getCatalog());

      try
      {
         compiler.compileEJBQL(
            metadata.getEjbQl(),
            metadata.getMethod().getReturnType(),
            metadata.getMethod().getParameterTypes(),
            metadata);
      }
      catch(Throwable t)
      {
         log.error(t.getMessage(), t);
         throw new DeploymentException("Error compiling EJB-QL statement for EJB '" +
            manager.getContainer().getBeanMetaData().getEjbName() + "': " + metadata.getEjbQl(), t);
      }

      setSQL(compiler.getSQL());

      // set select object
      if(compiler.isSelectEntity())
      {
         JDBCEntityBridge selectEntity = (JDBCEntityBridge) compiler.getSelectEntity();

         // set the select entity
         setSelectEntity(selectEntity);

         // set the preload fields
         JDBCReadAheadMetaData readahead = metadata.getReadAhead();
         if(readahead.isOnFind())
         {
            setEagerLoadGroup(readahead.getEagerLoadGroup());
            setOnFindCMRList(compiler.getLeftJoinCMRList());
         }
      }
      else if(compiler.isSelectField())
      {
         setSelectField((JDBCCMPFieldBridge)compiler.getSelectField());
      }
      else
      {
         setSelectFunction(compiler.getSelectFunction(), manager);
      }

      // get the parameter order
      setParameterList(compiler.getInputParameters());
   }
}
