/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jnp.server;

import java.net.UnknownHostException;

/** 
 * The Mbean interface for the jnp provider server.
 * 
 * @author Rickard Oberg
 * @author Scott.Stark@jboss.org
 * @version $Revision$
 */
public interface MainMBean
{
   // Attributes  ---------------------------------------------------
   
   void setRmiPort(int port);
   int getRmiPort();
   
   void setPort(int port);
   int getPort();

   void setBindAddress(String host) throws UnknownHostException;   
   String getBindAddress();

   void setRmiBindAddress(String host) throws UnknownHostException;   
   String getRmiBindAddress();

   void setBacklog(int backlog);   
   int getBacklog();

   /** Whether the MainMBean's Naming server will be installed as the NamingContext.setLocal global value */
   void setInstallGlobalService(boolean flag);
   boolean getInstallGlobalService();

   /** The RMIServerSocketFactory implementation class */
   void setClientSocketFactory(String factoryClassName)
      throws ClassNotFoundException, InstantiationException, IllegalAccessException;
   String getClientSocketFactory();
   
   /** The RMIServerSocketFactory implementation class */
   void setServerSocketFactory(String factoryClassName)
      throws ClassNotFoundException, InstantiationException, IllegalAccessException;
   String getServerSocketFactory();

   /** The JNPServerSocketFactory implementation class */
   void setJNPServerSocketFactory(String factoryClassName) 
      throws ClassNotFoundException, InstantiationException, IllegalAccessException;

   // Operations ----------------------------------------------------
   
   public void start() throws Exception;
   
   public void stop();
   
}