/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.management.j2ee.statistics;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.EJBStats;

/**
 * The JSR77.6.11 EJBStats implementation
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision$
 */
public abstract class EJBStatsImpl extends StatsBase
        implements EJBStats
{
   // Constants -----------------------------------------------------
   
   /** @since 4.0.2 */
   private static final long serialVersionUID = 4277191366915058098L;
   
   // Constructors --------------------------------------------------
   
   public EJBStatsImpl()
   {
      this(new CountStatisticImpl("CreateCount", "1", "Number of creates"),
              new CountStatisticImpl("RemoveCount", "1", "Number of removes"));
   }

   public EJBStatsImpl(CountStatistic createCount, CountStatistic removeCount)
   {
      addStatistic("CreateCount", createCount);
      addStatistic("RemoveCount", removeCount);
   }

// Begin javax.management.j2ee.statistics.EJBStats interface methods
   public CountStatistic getCreateCount()
   {
      return (CountStatistic) getStatistic("CreateCount");
   }

   public CountStatistic getRemoveCount()
   {
      return (CountStatistic) getStatistic("RemoveCount");
   }
// End javax.management.j2ee.statistics.EJBStats interface methods
}
