/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.management.j2ee.statistics;

import javax.management.*;
import javax.management.j2ee.Management;
import javax.ejb.EJBObject;
import javax.ejb.EJBHome;
import javax.ejb.CreateException;
import java.rmi.RemoteException;
import java.util.Set;

/**
 * Specifies statistics provided by a JCA resource
 * 
 * @author thomas.diesler@jboss.org
 */
public interface JCAStats extends Stats
{
   /**
    * Returns an array of JCAConnectionStats that provide statistics about the non-pooled connections associated with the referencing JCA resource statistics
    */
   public JCAConnectionStats[] getConnections();

   /**
    * Returns an array of JCAConnectionPool Stats that provide statistics about the connection pools associated with the referencing JCA resource statistics
    */
   public JCAConnectionPoolStats[] getConnectionPools();

}

