/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.jboss.axis.message;

import org.xml.sax.Attributes;

/**
 * Null implementation of the Attributes interface.
 *
 * @author David Megginson
 * @author Sam Ruby <rubys@us.ibm.com>
 */
public class NullAttributes implements Attributes
{

   public static final NullAttributes singleton = new NullAttributes();

   ////////////////////////////////////////////////////////////////////
   // Implementation of org.xml.sax.Attributes.
   ////////////////////////////////////////////////////////////////////


   /**
    * Return the number of attributes in the list.
    *
    * @return The number of attributes in the list.
    * @see org.xml.sax.Attributes#getLength
    */
   public int getLength()
   {
      return 0;
   }


   /**
    * Return an attribute's Namespace URI.
    *
    * @param index The attribute's index (zero-based).
    * @return The Namespace URI, the empty string if none is
    *         available, or null if the index is out of range.
    * @see org.xml.sax.Attributes#getURI
    */
   public String getURI(int index)
   {
      return null;
   }


   /**
    * Return an attribute's local name.
    *
    * @param index The attribute's index (zero-based).
    * @return The attribute's local name, the empty string if
    *         none is available, or null if the index if out of range.
    * @see org.xml.sax.Attributes#getLocalName
    */
   public String getLocalName(int index)
   {
      return null;
   }


   /**
    * Return an attribute's qualified (prefixed) name.
    *
    * @param index The attribute's index (zero-based).
    * @return The attribute's qualified name, the empty string if
    *         none is available, or null if the index is out of bounds.
    * @see org.xml.sax.Attributes#getQName
    */
   public String getQName(int index)
   {
      return null;
   }


   /**
    * Return an attribute's type by index.
    *
    * @param index The attribute's index (zero-based).
    * @return The attribute's type, "CDATA" if the type is unknown, or null
    *         if the index is out of bounds.
    * @see org.xml.sax.Attributes#getType(int)
    */
   public String getType(int index)
   {
      return null;
   }


   /**
    * Return an attribute's value by index.
    *
    * @param index The attribute's index (zero-based).
    * @return The attribute's value or null if the index is out of bounds.
    * @see org.xml.sax.Attributes#getValue(int)
    */
   public String getValue(int index)
   {
      return null;
   }


   /**
    * Look up an attribute's index by Namespace name.
    * <p/>
    * <p>In many cases, it will be more efficient to look up the name once and
    * use the index query methods rather than using the name query methods
    * repeatedly.</p>
    *
    * @param uri       The attribute's Namespace URI, or the empty
    *                  string if none is available.
    * @param localName The attribute's local name.
    * @return The attribute's index, or -1 if none matches.
    * @see org.xml.sax.Attributes#getIndex(java.lang.String,java.lang.String)
    */
   public int getIndex(String uri, String localName)
   {
      return -1;
   }


   /**
    * Look up an attribute's index by qualified (prefixed) name.
    *
    * @param qName The qualified name.
    * @return The attribute's index, or -1 if none matches.
    * @see org.xml.sax.Attributes#getIndex(java.lang.String)
    */
   public int getIndex(String qName)
   {
      return -1;
   }


   /**
    * Look up an attribute's type by Namespace-qualified name.
    *
    * @param uri       The Namespace URI, or the empty string for a name
    *                  with no explicit Namespace URI.
    * @param localName The local name.
    * @return The attribute's type, or null if there is no
    *         matching attribute.
    * @see org.xml.sax.Attributes#getType(java.lang.String,java.lang.String)
    */
   public String getType(String uri, String localName)
   {
      return null;
   }


   /**
    * Look up an attribute's type by qualified (prefixed) name.
    *
    * @param qName The qualified name.
    * @return The attribute's type, or null if there is no
    *         matching attribute.
    * @see org.xml.sax.Attributes#getType(java.lang.String)
    */
   public String getType(String qName)
   {
      return null;
   }


   /**
    * Look up an attribute's value by Namespace-qualified name.
    *
    * @param uri       The Namespace URI, or the empty string for a name
    *                  with no explicit Namespace URI.
    * @param localName The local name.
    * @return The attribute's value, or null if there is no
    *         matching attribute.
    * @see org.xml.sax.Attributes#getValue(java.lang.String,java.lang.String)
    */
   public String getValue(String uri, String localName)
   {
      return null;
   }


   /**
    * Look up an attribute's value by qualified (prefixed) name.
    *
    * @param qName The qualified name.
    * @return The attribute's value, or null if there is no
    *         matching attribute.
    * @see org.xml.sax.Attributes#getValue(java.lang.String)
    */
   public String getValue(String qName)
   {
      return null;
   }
}
