/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.axis.message;

import java.util.ArrayList;
import java.util.Iterator;

import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;

/**
 * wraps javax.xml.soap.MimeHeaders
 */
public class MimeHeadersImpl extends MimeHeaders
{
   public MimeHeadersImpl()
   {
   }

   public MimeHeadersImpl(javax.xml.soap.MimeHeaders h)
   {
      Iterator iterator = h.getAllHeaders();
      while (iterator.hasNext())
      {
         MimeHeader hdr = (MimeHeader)iterator.next();
         addHeader(hdr.getName(), hdr.getValue());
      }
   }
   
   public String toString()
   {
      ArrayList list = new ArrayList();
      Iterator it = getAllHeaders();
      while (it.hasNext())
      {
         list.add(it.next());
      }
      return list.toString();
   }
}