/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.axis.message;

import org.w3c.dom.Comment;
import org.w3c.dom.Node;
import org.w3c.dom.DOMException;
import org.w3c.dom.UserDataHandler;

/**
 * Most of methods are inherited from TEXT, defined for its Interface Marker
 * only
 *
 * @author Heejune Ahn (cityboy@tmax.co.kr)
 */
public class CommentImpl extends TextImpl implements Comment
{

   public CommentImpl(Node node)
   {
      super(node);
   }

   public boolean isComment()
   {
      return true;
   }

   // DOM3-API start ***************************************************************************************************

   public String getBaseURI()
   {
      return null;
   }

   public short compareDocumentPosition(Node other) throws DOMException
   {
      return 0;
   }

   public String getTextContent() throws DOMException
   {
      return null;
   }

   public void setTextContent(String textContent) throws DOMException
   {

   }

   public boolean isSameNode(Node other)
   {
      return false;
   }

   public String lookupPrefix(String namespaceURI)
   {
      return null;
   }

   public boolean isDefaultNamespace(String namespaceURI)
   {
      return false;
   }

   public String lookupNamespaceURI(String prefix)
   {
      return null;
   }

   public boolean isEqualNode(Node arg)
   {
      return false;
   }

   public Object getFeature(String feature, String version)
   {
      return null;
   }

   public Object setUserData(String key, Object data, UserDataHandler handler)
   {
      return null;
   }

   public Object getUserData(String key)
   {
      return null;
   }

   // DOM3-API end *****************************************************************************************************
}