/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.jboss.axis.encoding.ser;

import org.jboss.axis.AxisFault;
import org.jboss.axis.attachments.AttachmentUtils;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.DeserializerImpl;
import org.jboss.axis.message.SOAPHandler;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import javax.xml.namespace.QName;

/**
 * JAFDataHandler Serializer
 *
 * @author Rick Rineholt
 *         Modified by Rich Scheuerle <scheu@us.ibm.com>
 */
public class JAFDataHandlerDeserializer extends DeserializerImpl
{
   private static Logger log = Logger.getLogger(JAFDataHandlerDeserializer.class.getName());

   public void startElement(String namespace, String localName,
                            String prefix, Attributes attributes,
                            DeserializationContext context)
           throws SAXException
   {

      if (!context.isDoneParsing())
      {
         if (myElement == null)
         {
            try
            {
               myElement = makeNewElement(namespace, localName, prefix, attributes, context);
            }
            catch (AxisFault axisFault)
            {
               throw new SAXException(axisFault);
            }
            context.pushNewElement(myElement);
         }
      }
//        super.startElement(namespace, localName, qName, attributes, context);

      SOAPConstants soapConstants = context.getMessageContext().getSOAPConstants();

      QName type = context.getTypeFromAttributes(namespace,
              localName,
              attributes);
      if (log.isDebugEnabled())
      {
         log.debug(Messages.getMessage("gotType00", "Deser", "" + type));
      }

      String href = attributes.getValue(soapConstants.getAttrHref());
      if (href != null)
      {
         Object ref = context.getObjectByRef(href);
         log.debug("About to getActivationDataHandler for: " + ref);
         try
         {
            ref = AttachmentUtils.getActivationDataHandler((org.jboss.axis.Part)ref);
         }
         catch (AxisFault e)
         {
            log.debug("Failed to get activation data handler", e);
         }

         setValue(ref);
      }
   }

   /**
    * Deserializer interface called on each child element encountered in
    * the XML stream.
    */
   public SOAPHandler onStartChild(String namespace,
                                   String localName,
                                   String prefix,
                                   Attributes attributes,
                                   DeserializationContext context)
           throws SAXException
   {
      throw new SAXException(Messages.getMessage("noSubElements", namespace + ":" + localName));
   }
}
