/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.jboss.axis.encoding.ser;

import org.jboss.axis.encoding.Base64;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.DeserializerImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import javax.xml.namespace.QName;

/**
 * Deserializer for Base64
 *
 * @author Sam Ruby <rubys@us.ibm.com>
 *         Modified by @author Rich scheuerle <scheu@us.ibm.com>
 * @see <a href="http://www.w3.org/TR/xmlschema-2/#base64Binary">XML Schema 3.2.16</a>
 */
public class Base64Deserializer extends DeserializerImpl
{

   public QName xmlType;
   public Class javaType;

   StringBuffer buf = null;

   public Base64Deserializer(Class javaType, QName xmlType)
   {
      this.xmlType = xmlType;
      this.javaType = javaType;
   }

   /**
    * Handle any characters found in the data
    */
   public void characters(char[] chars, int start, int end)
           throws SAXException
   {
      // Characters are collected in a buffer because
      // SAX may chunk the data.
      if (buf == null)
      {
         buf = new StringBuffer();
      }
      buf.append(chars, start, end);
   }

   public void onStartElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException
   {
      super.onStartElement(namespace, localName, prefix, attributes, context);
   }

   /**
    * Return something even if no characters were found.
    */
   public void onEndElement(String namespace, String localName,
                            DeserializationContext context)
           throws SAXException
   {
      // Decode the collected characters
      if (buf != null)
      {
         value = Base64.decode(buf.toString());
         if (javaType == Byte[].class)
         {
            Byte[] data = new Byte[((byte[])value).length];
            for (int i = 0; i < data.length; i++)
            {
               byte b = ((byte[])value)[i];
               data[i] = new Byte(b);
            }
            value = data;
         }
      }

      super.onEndElement(namespace, localName, context);
      // If no value was specified, return a zero length byte or Byte array
      if (!isNil && value == null)
      {
         if (javaType == byte[].class)
         {
            value = new byte[0];
         }
         else
         {
            value = new Byte[0];
         }
      }
   }
}
