/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the docs/licenses/apache-1.1.txt file.
 */

package org.jboss.axis.attachments;


import org.jboss.axis.Part;


/**
 *
 * @author Rick Rineholt 
 */

/**
 * This simulates the multipart stream
 */
public abstract class MultiPartInputStream extends
        java.io.FilterInputStream
{

   MultiPartInputStream(java.io.InputStream is)
   {
      super(is);
   }

   public abstract Part getAttachmentByReference(final String[] id)
           throws org.jboss.axis.AxisFault;

   public abstract java.util.Collection getAttachments()
           throws org.jboss.axis.AxisFault;

   /**
    * Return the content location.
    *
    * @return the Content-Location of the stream.
    *         Null if no content-location specified.
    */
   public abstract String getContentLocation();

   /**
    * Return the content id of the stream
    *
    * @return the Content-Location of the stream.
    *         Null if no content-location specified.
    */
   public abstract String getContentId();

}
