/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the docs/licenses/apache-1.1.txt file.
 */
package org.jboss.axis.attachments;


import org.jboss.axis.utils.Messages;


/**
 * This class is a single part for DIME mulitpart message.
 */


public final class DimeTypeNameFormat
{
   private byte format = 0;

   private DimeTypeNameFormat()
   {
   }

   private DimeTypeNameFormat(byte f)
   {
      format = f;
   }

   //Current type values.
   static final byte NOCHANGE_VALUE = 0x00; // indicates the type is unchanged from the previous record (used for chunking)
   static final byte MIME_VALUE = 0x01; //indicates the type is specified as a MIME media-type
   static final byte URI_VALUE = 0x02; // indicates the type is specified as an absolute URI
   static final byte UNKNOWN_VALUE = 0x03; // indicates the type is not specified
   static final byte NODATA_VALUE = 0x04; // indicates the record has no payload

   static final DimeTypeNameFormat NOCHANGE =
           new DimeTypeNameFormat(NOCHANGE_VALUE);

   public static final DimeTypeNameFormat MIME =
           new DimeTypeNameFormat(MIME_VALUE);

   public static final DimeTypeNameFormat URI =
           new DimeTypeNameFormat(URI_VALUE);

   public static final DimeTypeNameFormat UNKNOWN =
           new DimeTypeNameFormat(UNKNOWN_VALUE);

   static final DimeTypeNameFormat NODATA =
           new DimeTypeNameFormat(NODATA_VALUE);

   private static String[] toEnglish = {"NOCHANGE", "MIME", "URI",
                                        "UNKNOWN", "NODATA"};
   private static DimeTypeNameFormat[] fromByte = {NOCHANGE, MIME,
                                                   URI, UNKNOWN, NODATA};

   public final String toString()
   {
      return toEnglish[format];
   }

   public final byte toByte()
   {
      return format;
   }

   public final boolean equals(final Object x)
   {
      if (x == null)
      {
         return false;
      }
      if (!(x instanceof DimeTypeNameFormat))
      {
         return false;
      }
      return ((DimeTypeNameFormat)x).format == this.format;
   }

   public static DimeTypeNameFormat parseByte(byte x)
   {
      if (x < 0 || x > fromByte.length)
      {
         throw new IllegalArgumentException(Messages.getMessage("attach.DimeStreamBadType", "" + x));
      }
      return fromByte[x];
   }

   public static DimeTypeNameFormat parseByte(Byte x)
   {
      return parseByte(x.byteValue());
   }
}
