/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the docs/licenses/apache-1.1.txt file.
 */

package org.jboss.axis.attachments;


/**
 * This class hold all parts of a DIME multipart message.
 * @author Rick Rineholt 
 */

public final class DimeMultiPart
{
   static final long transSize = Integer.MAX_VALUE;
   static final byte CURRENT_VERSION = 1; //Anything above this we don't support.
   protected java.util.Vector parts = new java.util.Vector();

   public DimeMultiPart()
   {
   }

   public void addBodyPart(DimeBodyPart part)
   {
      parts.add(part);
   }

   public void write(java.io.OutputStream os)
           throws java.io.IOException
   {
      int size = parts.size();
      int last = size - 1;

      for (int i = 0; i < size; ++i)
         ((DimeBodyPart)parts.elementAt(i)).write(os,
                 (byte)((i == 0 ? DimeBodyPart.POSITION_FIRST :
                 (byte)0)
                 | (i == last ? DimeBodyPart.POSITION_LAST :
                 (byte)0)), transSize);
   }

   public long getTransmissionSize()
   {
      long size = 0;

      for (int i = parts.size() - 1; i > -1; --i)
         size +=
                 ((DimeBodyPart)parts.elementAt(i)).getTransmissionSize(transSize);

      return size;
   }
}
