/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the docs/licenses/apache-1.1.txt file.
 */

package org.jboss.axis;

/**
 * If a Java class which acts as the target for an Axis service
 * implements this interface, it may convey metadata about its
 * configuration to the Axis engine.
 *
 * @author Glen Daniels (gdaniels@macromedia.com)
 */
public interface AxisServiceConfig
{
   /**
    * Get the allowed method names.
    *
    * @return a space-delimited list of method names which may be called
    *         via SOAP.
    */
   public String getAllowedMethods();
}
