/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.bind;

// $Id$

import org.w3c.dom.Node;

import java.net.URL;

/**
 * Encapsulate the location of a ValidationEvent.
 *
 * The ValidationEventLocator indicates where the ValidationEvent occurred. Different fields will be set depending on
 * the type of validation that was being performed when the error or warning was detected. For example, on-demand
 * validation would produce locators that contained references to objects in the Java content tree while unmarshal-time
 * validation would produce locators containing information appropriate to the source of the XML data (file, url, Node, etc).
 *
 * @author Thomas.Diesler@jboss.org
 * @since 18-Oct-2004
 */
public interface ValidationEventLocator
{
   /** Return the column number if available
    */
   int getColumnNumber();

   /** Return the line number if available
    */
   int getLineNumber();

   /** Return a reference to the DOM Node if available
    */
   Node getNode();

   /** Return a reference to the object in the Java content tree if available
    */
   Object getObject();

   /** Return the byte offset if available
    */
   int getOffset();

   /** Return the name of the XML source as a URL if available
    */
   URL getURL();
}
