/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.bind;

// $Id$

import org.w3c.dom.Node;
import org.xml.sax.InputSource;

import javax.xml.transform.Source;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

/**
 * The Unmarshaller class governs the process of deserializing XML data into newly created Java content trees,
 * optionally validating the XML data as it is unmarshalled.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 18-Oct-2004
 */
public interface Unmarshaller
{
   /** Return the current event handler or the default event handler if one hasn't been set.
    */
   ValidationEventHandler getEventHandler() throws JAXBException;

   /** Get the particular property in the underlying implementation of Unmarshaller.
    */
   Object getProperty(String name) throws PropertyException;

   /** Get an unmarshaller handler object that can be used as a component in an XML pipeline.
    */
   UnmarshallerHandler getUnmarshallerHandler();

   /** Indicates whether or not the Unmarshaller is configured to validate during unmarshal operations.
    */
   boolean isValidating() throws JAXBException;

   /** Allow an application to register a ValidationEventHandler.
    */
   void setEventHandler(ValidationEventHandler handler) throws JAXBException;

   /** Set the particular property in the underlying implementation of Unmarshaller.
    */
   void setProperty(String name, Object value) throws PropertyException;

   /** Specifies whether or not the default validation mechanism of the Unmarshaller should validate during unmarshal operations.
    *
    */
   void setValidating(boolean validating) throws JAXBException;

   /** Unmarshal XML data from the specified file and return the resulting content tree.
    */
   Object unmarshal(File file) throws JAXBException;

   /** Unmarshal XML data from the specified SAX InputSource and return the resulting content tree.
    *
    */
   Object unmarshal(InputSource source) throws JAXBException;

   /** Unmarshal XML data from the specified InputStream and return the resulting content tree.
    */
   Object unmarshal(InputStream is) throws JAXBException;

   /** Unmarshal XML data from the specified DOM tree and return the resulting content tree.
    */
   Object unmarshal(Node node) throws JAXBException;

   /** Unmarshal XML data from the specified XML Source and return the resulting content tree.
    */
   Object unmarshal(Source source) throws JAXBException;

   /** Unmarshal XML data from the specified URL and return the resulting content tree.
    */
   Object unmarshal(URL url) throws JAXBException;
}
