/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.bind;

import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

import javax.xml.transform.Result;

// $Id$

/**
 * The Marshaller class is responsible for governing the process of serializing Java content trees back into XML data.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 18-Oct-2004
 */
public interface Marshaller
{
   /** The name of the property used to specify the output encoding in the marshalled XML data. */
   static String JAXB_ENCODING = "jaxb.encoding";

   /** The name of the property used to specify whether or not the marshalled XML data is formatted with linefeeds and indentation. */
   static String JAXB_FORMATTED_OUTPUT = "jaxb.formatted.output";

   /** The name of the property used to specify the the xsi:noNamespaceSchemaLocation attribute value to place in the marshalled XML output. */
   static String JAXB_NO_NAMESPACE_SCHEMA_LOCATION = "jaxb.noNamespaceSchemaLocation";

   /** The name of the property used to specify the xsi:schemaLocation attribute value to place in the marshalled XML output. */
   static String JAXB_SCHEMA_LOCATION = "jaxb.schemaLocation";

   /** Return the current event handler or the default event handler if one hasn't been set.
    */
   ValidationEventHandler getEventHandler() throws JAXBException;

   /** Get a DOM tree view of the content tree(Optional).
    */
   Node getNode(Object contentTree) throws JAXBException;

   /** Get the particular property in the underlying implementation of Marshaller.
    */
   Object getProperty(String name) throws PropertyException;

   /** Marshal the content tree rooted at obj into SAX2 events.
    */
   void marshal(Object obj, ContentHandler handler) throws JAXBException;

   /** Marshal the content tree rooted at obj into a DOM tree.
    */
   void marshal(Object obj, Node node) throws JAXBException;

   /** Marshal the content tree rooted at obj into an output stream.
    */
   void marshal(Object obj, java.io.OutputStream os) throws JAXBException;

   /** Marshal the content tree rooted at obj into the specified javax.xml.transform.Result.
    */
   void marshal(Object obj, Result result) throws JAXBException;

   /** Marshal the content tree rooted at obj into a Writer.
    */
   void marshal(Object obj, java.io.Writer writer) throws JAXBException;

   /** Allow an application to register a validation event handler.
    */
   void setEventHandler(ValidationEventHandler handler) throws JAXBException;

   /** Set the particular property in the underlying implementation of Marshaller.
    *
    */
   void setProperty(String name, Object value) throws PropertyException;
}
