/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.bind;

// $Id$

/**
 * This exception indicates that an error has occurred while performing a marshal
 * operation that the provider is unable to recover from.
 *
 * The ValidationEventHandler can cause this exception to be thrown during the marshal operations.
 * See ValidationEventHandler.handleEvent(ValidationEvent).
 *
 * @author Thomas.Diesler@jboss.org
 * @since 18-Oct-2004
 */
public class MarshalException extends JAXBException
{
   /** Construct a MarshalException with the specified detail message. */
   public MarshalException(String message)
   {
      super(message);
   }

   /** Construct a MarshalException with the specified detail message and vendor specific errorCode. */
   public MarshalException(String message, String errorCode)
   {
      super(message, errorCode);
   }

   /** Construct a MarshalException with the specified detail message, vendor specific errorCode, and linkedException. */
   public MarshalException(String message, String errorCode, Throwable exception)
   {
      super(message, errorCode, exception);
   }


   /** Construct a MarshalException with the specified detail message and linkedException. */
   public MarshalException(String message, Throwable exception)
   {
      super(message, exception);
   }

   /** Construct a MarshalException with a linkedException. */
   public MarshalException(Throwable exception)
   {
      super(exception);
   }

}
