/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.test.timer;

import java.util.Date;
import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timer;
import javax.ejb.TimerService;

import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.logging.Logger;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
@Stateless
@RemoteBinding(jndiBinding="TimerTesterBean21")
@Remote(TimerTester.class)
public class TimerTesterBean21 implements TimerTester, javax.ejb.TimedObject
{
   private static final Logger log = Logger.getLogger(TimerTesterBean21.class);
   
   public static boolean timerCalled = false;

   private @Resource TimerService timerService;

   private @Resource SessionContext ctx;
   
   private Timer timer;

   public void startTimer(long pPeriod)
   {
      timerCalled = false;
      System.out.println("************ startTimer");
      timer = timerService.createTimer(new Date(new Date().getTime() + pPeriod), "TimerSLSBean");
      
   }

   public void startTimerViaEJBContext(long pPeriod)
   {
      timerCalled = false;
      System.out.println("************ startTimerViaEJBContext");
      timer = ctx.getTimerService().createTimer(new Date(new Date().getTime() + pPeriod), "TimerSLSBean");
   }

   public void accessTimer()
   {
      //Access timer to make sure we have pushed the AllowedOperationsAssociation
      timer.getTimeRemaining();
      timer.getHandle();
      timer.getInfo();
   }
   
   public boolean isTimerCalled()
   {
      return timerCalled;
   }

   public void ejbTimeout(Timer timer)
   {
      log.info("EJB TIMEOUT!!!!");
      timerCalled = true;
      timer.cancel();
   }
}
