/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.test.stateless.unit;

import javax.ejb.EJBAccessException;

import org.jboss.ejb3.test.stateless.AnonymousStateless;
import org.jboss.ejb3.test.stateless.CheckedStateless;
import org.jboss.ejb3.test.stateless.UnsecuredStateless;
import org.jboss.ejb3.test.stateless.RunAsStateless;
import org.jboss.ejb3.test.stateless.RunAsStatelessLocal;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.test.JBossTestCase;
import junit.framework.Test;

/**
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 * @version $Revision$
 */
public class StatelessTestCase extends JBossTestCase
{
   private static final Logger log = Logger.getLogger(StatelessTestCase.class);

   static boolean deployed = false;
   static int test = 0;

   public StatelessTestCase(String name)
   {
      super(name);
   }
 
   public void testCallerPrincipal() throws Exception
   {
      SecurityAssociation.setPrincipal(new SimplePrincipal("somebody"));
      SecurityAssociation.setCredential("password".toCharArray());
       
      RunAsStateless runAs = (RunAsStateless) getInitialContext().lookup("RunAsStatelessEjbName/remote");
      assertNotNull(runAs);
      
      String principal = runAs.getCallerPrincipal();
      assertEquals("somebody", principal);
      
      principal = runAs.getCheckedCallerPrincipal();
      assertEquals("somebody", principal);
   }
   
   public void testRunAs() throws Exception
   {
      CheckedStateless checked = (CheckedStateless)getInitialContext().lookup("CheckedStatelessBean/remote");
      
      SecurityAssociation.setPrincipal(new SimplePrincipal("somebody"));
      SecurityAssociation.setCredential("password".toCharArray());
      
      int result = checked.method(1);
      assertEquals(1,result);
      
      SecurityAssociation.setPrincipal(new SimplePrincipal("rolefail"));
      SecurityAssociation.setCredential("password".toCharArray());
      
      try {
         checked.method(2);
         assertTrue(false);
      } catch (Exception e){
         assertTrue(e instanceof EJBAccessException);
      }
      
      RunAsStateless runAs =
            (RunAsStateless) getInitialContext().lookup("RunAsStatelessEjbName/remote");
      
      int i = runAs.method(3);
      assertEquals(3, i);
   } 
   
   public void testAnonymous() throws Exception
   {
      AnonymousStateless anonymous = (AnonymousStateless)getInitialContext().lookup("AnonymousStatelessBean/remote");
      
      SecurityAssociation.clear();
      
      try
      {
         anonymous.method(1);
//         fail();
      } 
      catch (Exception e)
      {
 //        throw e;
      }
   }
   
   public void testUnsecureToSecure() throws Exception
   {
      UnsecuredStateless stateless = (UnsecuredStateless)getInitialContext().lookup("UnsecuredStatelessBean/remote");
      
      SecurityAssociation.clear();
      
      try
      {
         stateless.method(1);
         fail();
      }
      catch (Exception e)
      {
         
      }
      
      SecurityAssociation.setPrincipal(new SimplePrincipal("somebody"));
      SecurityAssociation.setCredential("password".toCharArray());
      
      assertEquals(1, stateless.method(1));
      
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(StatelessTestCase.class, "stateless-test.jar");
   }
}